;#===============================================================================
;# 傶̂vH[
;# ʃCu ver.1.06  Copyright 1997-2005 JoJo's Web Lab.
;#
;#   File:  jscm.pl
;#   URL: http://www.starwars.jp/web/        Email: webmaster@starwars.jp
;#
;#   ̃\tg̓t[\tgłB
;#   Epp͎RłAĔzz͋֎~܂B
;#   p̍ۂ̑QɂĂ͈ؕۏ؂܂B
;#===============================================================================
;# XV
;#
;# 2004/10/06   ver.1.06    URLNŁAJ}i,ĵURLr؂Ȃ悤ɂB
;# 2004/03/02   ver.1.05    }`p[gΉ̃tH[擾֐ǉB
;#                          摜widthAheight̎擾֐ǉB
;#                          CGĨo[W\֐ǉB
;# 2003/06/11   ver.1.04    ^O̓WJ2߂ " 𕜋AłȂoOCB
;# 2002/12/08   ver.1.03    N target t@\ǉB
;#                          WHTTPwb_o͊֐ǉB
;#                          WHTTPwb_tŃG[bZ[Wo͂֐ǉB
;# 2001/11/27   ver.1.02    COT[oɂ鎞̌vZIɍs悤ɂB
;# 2001/07/24   ver.1.01    bZ[WTCY傫ꍇ̃G[bZ[WǉB
;#                          Content-Lengthwb_̏o͉ۃtOǉB
;#                          GET\bh̃G[bZ[WĂ̂CB
;# 2001/05/09   ver.1.00    񃊃[X
;#
;#===============================================================================
package jscm;

# {Cũo[W
$version   = '1.06';

# Cu
$libname   = 'jscm.pl';

# R[hZbg
#
#   ʏ̓vOŏ̂ŁA̕ύX͕svłB
#
$charset   = 'Shift_JIS';

#
# OjbWW̎
#
#   {ł+9ԁBCOT[ołT}[^C܂߂Ăŕʂ͋zł͂A
#   ł덷ꍇ͂ŕ␳ibPʁjB
#
$difftime  = 9*60*60;

#
# Content-Lengthwb_̏o̓tO
#
#   IɍL}T[oœȂꍇ͂ 0 ɂ
#
$cntlenflg = 1;


;#===============================================================================
;# HTTPWwb_̏o
;#      FR[hZbg, [LastModifiedΏۃt@CpX]
;#      ߒlFȂ
;#===============================================================================
sub outStdHeader
{
    my ($charset, $file) = @_;
    print "Status: 200 OK\n";
    print "Content-Type: text/html; charset=$charset\n";
    print "Content-Style-Type: text/css\n";
    print "Content-Script-Type: text/javascript\n";
    print "Content-Language: ja\n";
    if ($file) {
        print "Last-Modified: " . getLastModified($file) . "\n";
    }
    print "\n";
}

;#===============================================================================
;# Locationwb_̏o
;#      FړURL
;#      ߒlFȂ
;#===============================================================================
sub outLocation
{
    my ($url) = @_;
    print "Status: 302 Found\n";
    print "Location: $url\n";
    print "\n";
    exit(0);
}

;#===============================================================================
;# t@Č납̓ǂݍ
;#      Ft@C, s, z̃t@X
;#      ߒlFȂ
;#===============================================================================
sub tailFile
{
    my ($file, $num, $ref) = @_;
    my $size = 0;
    my $pos = 0;
    my $bufsize = 1024;
    my $buf = '';
    my $tmp = '';
    my @dat = ();
    open(FILE, $file) || outError(3, $file);
    eval { flock(FILE, 1); };
    binmode(FILE);
    $size = (-s FILE) / $bufsize;
    $pos += $size <=> ($pos = int($size));
    while ($pos--) {
        seek(FILE, $bufsize * $pos, 0);
        read(FILE, $buf, $bufsize);
        $buf .= $tmp;
        ($tmp, @dat) = $buf =~ /[^\r\n]*\r?\n?/g;
        pop(@dat);
        unshift(@$ref, @dat);
        last if @$ref >= $num;
    }
    close(FILE);
    unshift(@$ref, $tmp);
    @$ref = @$ref[-$num .. -1] if (@$ref > $num);
}

;#===============================================================================
;# t@Cꗗ̓ǂݍ
;#      FfBNg, z̃t@X, [gq]
;#      ߒlF擾fBNg
;#===============================================================================
sub readDir
{
    my ($dir, $ref, $exp) = @_;
    my $cnt = 0;
    my @tmp = ();
    opendir(DIR, $dir) || outError(4, $dir);
    @tmp = readdir(DIR);
    foreach (@tmp) {
        next if ($exp && index($_, ".$exp") < 0);
        next if ($_ eq '.' || $_ eq '..');
        push(@$ref, $_);
        $cnt++;
    }
    closedir(DIR);
    return $cnt;
}

;#===============================================================================
;# t@C̉ʕ\
;#      Ft@C
;#      ߒlFȂ
;#===============================================================================
sub printFile
{
    my ($file) = @_;
    my $size;
    $size = (-s $file);
    print "Content-Length: $size\n" if ($cntlenflg);
    print "\n";
    open(FILE, $file) || outError(3, $file);
    eval { flock(FILE, 1); };
    print $_ while (<FILE>);
    close(FILE);
}

;#===============================================================================
;# t̍쐬
;#      FtH[}bg, [timeϐ], []
;#      ߒlFt
;#===============================================================================
sub makeDate
{
    my ($fmt, $tt, $diff) = @_;
    $tt = time unless ($tt);
    $diff *= 3600;
    my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = gmtime($tt + $difftime + $diff);
    $year += 1900;
    $year2 = sprintf("%02d", $year % 100);
    $mon  = sprintf("%02d", ++$mon);
    $mday = sprintf("%02d", $mday);
    $hour = sprintf("%02d", $hour);
    $min  = sprintf("%02d", $min);
    $day  = ('','','','','','','y')[$wday];
    $fmt =~ s/yyyy/$year/;
    $fmt =~ s/yy/$year2/;
    $fmt =~ s/mm/$mon/;
    $fmt =~ s/dd/$mday/;
    $fmt =~ s/w/$day/;
    $fmt =~ s/hh/$hour/;
    $fmt =~ s/nn/$min/;
    return $fmt;
}

;#===============================================================================
;# tH[̃fR[hi}`p[gΉ/Ήpj
;#      FnbṼt@X, GETetO/t@Ci[fBNg, [R[hZbg]
;#      ߒlFȂ
;#===============================================================================
sub getForm
{
    my ($p1, $p2, $p3) = @_;
    if (index($ENV{'CONTENT_TYPE'}, 'multipart') < 0) {
        jscm::getForm1($p1, $p2, $p3);
    } else {
        jscm::getForm2($p1, $p2, $p3);
    }
}

;#===============================================================================
;# tH[̃fR[hi}`p[gΉj
;#      FnbṼt@X, [GETetO], [R[hZbg]
;#      ߒlFȂ
;#===============================================================================
sub getForm1
{
    my ($ref, $get, $charset) = @_;
    my $str  = '';
    if ($ENV{'REQUEST_METHOD'} eq 'POST') {
        read(STDIN, $str, $ENV{'CONTENT_LENGTH'});
    } else {
        $str = $ENV{'QUERY_STRING'} if ($get);
    }
    foreach (split(/[&;]/, $str)) {
        my ($name, $value) = split(/=/);
        $value =~ tr/+/ /;
        $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        $value =~ tr/\t/ /d;
        jcode::convert(*value, $charset) if ($charset);
        $$ref{$name} = $value;
    }
}

;#===============================================================================
;# tH[̃fR[hi}`p[gΉj
;#      FnbṼt@X, t@Ci[fBNg, [R[hZbg]
;#      ߒlFȂ
;#===============================================================================
sub getForm2
{
    my ($ref, $file_dir, $charset) = @_;
    my ($boundary, $key, $value, $path, $flag, $file, $text, $open, $i)
        = ('', '', '', '', 0, '', '', '', 0);

    $boundary = $1 if ($ENV{'CONTENT_TYPE'} =~ /^multipart\/form-data; *boundary=(.+)/);
    binmode(STDIN);
    while (<STDIN>) {
        if ($flag == 2) {
            if (/^--$boundary/) {
                $value =~ s/\r\n$//;
                if ($text) {
                    jcode::convert(*value, $charset) if ($charset);
                    $value =~ s/\r\n|\r/\n/g;
                    $value =~ tr/\t\a\b\e\f//d;
                }
                if ($open) {
                    close(OUT);
                    $$ref{$key} = $file;
                } else {
                    $$ref{$key} = $value;
                }
                $$ref{"$key->name"} = $1 if ($path =~ /([^\\\/]+)$/);
                ($text, $flag, $path, $open, $file, $key, $value) = undef;
                last if (/--\r\n$/);
            } elsif ($open) {
                print OUT $_;
            } else {
                $value .= $_;
            }
        } elsif ($flag && /^\r\n$/) {
            $flag = 2;
        } elsif (/^Content-Disposition: *([^;]*); *name="([^;]*)"; *filename="([^;]*)"/i) {
            $key  = $2;
            $path = $3;
            $flag = 1;
            if ($path && $file_dir && ! $$ref{"$key->name"}) {
                $i++;
                $file = sprintf("%010d%05d%d", time, $$, $i);
                if (open(OUT, ">$file_dir/$file")) {
                    binmode(OUT);
                    $open = 1;
                }
            }
        } elsif (/^Content-Disposition: *([^;]*); *name="([^;]*)"/i) {
            $key  = $2;
            $flag = 1;
            $text = 1;
        }
    }
}

;#===============================================================================
;# Last-Modifiedwb_̏
;#      Ft@CpX
;#      ߒlFoׂ͂Last-Modifiedwb_̒l
;#===============================================================================
sub getLastModified
{
    my ($file) = @_;
    my ($mtime, $day, $mon);
    my $last = '';
    ($mtime) = (stat($file))[9];
    my ($gsec, $gmin, $ghour, $gmday, $gmon, $gyear, $gwday, $gyday, $gisdst) = gmtime($mtime);
    $day = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat')[$gwday];
    $mon = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec')[$gmon];
    $last = sprintf("%s, %02d %s %04d %02d:%02d:%02d GMT",
            $day, $gmday, $mon, $gyear+1900, $ghour, $gmin, $gsec);
    return $last;
}

;#===============================================================================
;# HTML^O̓WJ
;#      F"/"؂̋^O, ^Oꗗ̃t@X
;#      ߒlFȂ
;#===============================================================================
sub getTag
{
    my ($str, $ref) = @_;
    $str =~ tr/A-Z/a-z/;
    @$ref = split(/\//, $str);
}

;#===============================================================================
;# HTML^Õ`FbN
;#      F^O蕶, ^Oꗗ̃t@X
;#      ߒlFϊ㕶
;#===============================================================================
sub checkTag
{
    my ($str, $ref) = @_;
    $$str =~ s/&/&amp;/g;
    $$str =~ s/"/&quot;/g;
    $$str =~ s/</&lt;/g;
    $$str =~ s/>/&gt;/g;
    foreach (@$ref) {
        $$str =~ s|&lt;$_&gt;|<$_>|gi;
        $$str =~ s|&lt;$_(\s+(.*?))&gt;|<$_$1>|gi;
        $$str =~ s|&lt;/(\s*$_\s*)&gt;|</$1>|gi;
        1 while $$str =~ s|(<$_\s+.+)&quot;(.*>)|$1"$2|g;
    }
}

;#===============================================================================
;# 񒆂̉sR[h "\n" ɕϊ
;#      F̃t@X
;#      ߒlFȂ
;#===============================================================================
sub encodeBr
{
    local($ref) = @_;
    $$ref =~ s/\\/\\\\/g;
    $$ref =~ s/\x0d\x0a/\\n/g;
    $$ref =~ s/\x0d/\\n/g;
    $$ref =~ s/\x0a/\\n/g;
}

;#===============================================================================
;# 񒆂 "\n" sR[hɕϊ
;#      F̃t@X
;#      ߒlFȂ
;#===============================================================================
sub decodeBr
{
    local($ref) = @_;
    $$ref =~ s/\\\\/\0/g;
    $$ref =~ s/\\n/\n/g;
    $$ref =~ s/\0/\\/g;
}

;#===============================================================================
;# 񒆂URLA[AhXNɕϊ
;#      F̃t@X, [target̒l]
;#      ߒlFȂ
;#===============================================================================
sub autoLink
{
    local($ref, $target) = @_;
    $target = " target=\"$target\"" if ($target);
    $$ref =~ s/([^="',;]|^)((http|https|ftp):\/\/[\w\.\/\-+#?~&%=^\@:;,]+)(["']*)/$1<a href="$2"$target>$2<\/a>$4/ig;
    $$ref =~ s/([\w\+-\.]+@[\w\+-]+\.[\w\+\.-]+)/<a href="mailto:$1">$1<\/a>/ig;
}

;#===============================================================================
;# 񒆂̈p}[NAbv
;#      F̃t@X
;#      ߒlFȂ
;#===============================================================================
sub markQuote
{
    my ($ref) = @_;
    my $buf = '';
    my @tmp = ();
    @tmp = split(/\n/i, $$ref);
    foreach (@tmp) {
        $_ =~ s/(^( |@)*(&gt;|).*$)/<q>$1<\/q>/;
        $_ =~ s/^( |@)*>(.*$)/<q>$1&gt;$2<\/q>/;
        $buf .= "$_\n";
    }
    $$ref = $buf;
}

;#===============================================================================
;# URLGR[h
;#      F̃t@X
;#      ߒlFȂ
;#===============================================================================
sub encodeString
{
    local($ref) = @_;
    $$ref =~ s/(\W)/sprintf("%%%02X", unpack("C", $1))/eg;
}

;#===============================================================================
;# URLfR[h
;#      F̃t@X
;#      ߒlFȂ
;#===============================================================================
sub decodeString
{
    local($ref) = @_;
    $$ref =~ s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("C", hex($1))/eg;
}

;#===============================================================================
;# 摜TCY̎擾
;#      F摜t@CpXigif/jpg/pngj
;#      ߒlFWidth, Height
;#===============================================================================
sub getImageSize
{
    my ($file) = @_;
    local $_;

    open(IN, $file) || return (-1, -1);
    binmode(IN);
    read(IN, $_, 8);
    if ($_ eq "\x89\x50\x4e\x47\x0d\x0a\x1a\x0a") {     # PNG̏ꍇ
        my ($width, $height) = getPngSize(*IN);
        close(IN);
        return ($width, $height);
    }
    $_ = substr($_, 0, 3);
    if ($_ eq "\x47\x49\x46") {                         # GIF̏ꍇ
        my ($width, $height) = getGifSize(*IN);
        close(IN);
        return ($width, $height);
    }
    $_ = substr($_, 0, 2);
    if ($_ eq "\xff\xd8") {                             # JPG̏ꍇ
        my ($width, $height) = getJpgSize(*IN);
        close(IN);
        return ($width, $height);
    }
    close(IN);
    return (-1, -1);
}

# PNG摜̃TCY擾
sub getPngSize
{
    local (*IN) = @_;
    local $image = '';
    local @chunk;
    seek(IN, 0, 0);
    $image .= $_ while (<IN>);
    @chunk = unpack("C"x8, substr($image, 16, 8));
    return ($chunk[0] << 24 | $chunk[1] << 16 | $chunk[2] << 8 | $chunk[3], $chunk[4] << 24 | $chunk[5] << 16 | $chunk[6] << 8 | $chunk[7]);
}

# GIF摜̃TCY擾
sub getGifSize
{
    local (*IN) = @_;
    local $_;
    my ($width, $height) = (0, 0);
    seek(IN, 6, 0);
    read(IN, $_, 4);
    ($width, $height) = unpack("vv", $_);
    if ($width > 0 && $height > 0) {
        return ($width, $height);
    } else {
        return (-1, -1);
    }
}

# JPG摜̃TCY擾
sub getJpgSize
{
    local (*IN) = @_;
    local $_;
    my ($width, $height, $w1, $w2, $h1, $h2, $l1, $l2, $length)
        = (0, 0, 0, 0, 0, 0, 0, 0, 0);
    seek(IN, 2, 0);
    while (read(IN, $_, 1)) {
        return (-1, -1) unless ($_);
        if ($_ eq "\xff") {
            $_ = getc(IN);
            if (/^[\xc0-\xc3\xc5-\xcf]$/) {
                seek(IN, 3, 1);
                return (-1, -1) if (read(IN, $_, 4) != 4);
                ($h1, $h2, $w1, $w2) = unpack("C4", $_);
                $height = $h1 * 256 + $h2;
                $width  = $w1 * 256 + $w2;
                return ($width, $height);
            } elsif ($_ eq "\xd9" || $_ eq "\xda") {
                return (-1, -1);
            } else {
                return (-1, -1) if (read(IN, $_, 2) != 2);
                ($l1, $l2) = unpack("CC", $_);
                $length = $l1 * 256 + $l2;
                seek(IN, $length - 2, 1);
            }
        }
    }
    return (-1, -1);
}

;#===============================================================================
;# CGĨo[W̕\
;#      FCGI, o[W
;#      ߒlFȂ
;#===============================================================================
sub viewVersion
{
    my ($cgi, $ver) = @_;
    return if ($ENV{'REQUEST_METHOD'} ne 'GET' || $ENV{'QUERY_STRING'} ne 'version');
    outStdHeader($charset);

print <<"EOF";

<?xml version="1.0" encoding="$charset" ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>o[W</title>
</head>
<body>
<p>$cgi F ver.$ver<br />jscm.pl F ver.$version</p>
<p>Copyright(c) 1997-2004 JoJo's Web Lab.<br />
URL: <a href="http://www.starwars.jp/web/">http://www.starwars.jp/web/</a><br />
Email: <a href="mailto:webmaster\@starwars.jp">webmaster\@starwars.jp</a>
</p>
</body>
</html>
EOF

    exit(0);
}

;#===============================================================================
;# G[ʂ̕\iHTTPwb_̏o͕tj
;#      F[G[ԍ/G[bZ[W], [l]
;#      ߒlFȂ
;#===============================================================================
sub outError
{
    my ($err, $etc) = @_;
    outStdHeader($charset);
    outError2($err, $etc);
}

;#===============================================================================
;# G[ʂ̕\
;#      F[G[ԍ/G[bZ[W], [l]
;#      ߒlFȂ
;#===============================================================================
sub outError2
{
    my ($err, $etc) = @_;
    if    ($err <   0) { $mes = "s̃G[łB";                                          }
    elsif ($err ==  1) { $mes = "pX[hႢ܂B";                                          }
    elsif ($err ==  2) { $mes = "Kvȏi$etcjɕs܂B";                            }
    elsif ($err ==  3) { $mes = "t@CG[łB[$etc]";                                      }
    elsif ($err ==  4) { $mes = "fBNgG[łB[$etc]";                                  }
    elsif ($err ==  5) { $mes = "de͂ł܂B";                                          }
    elsif ($err ==  6) { $mes = "gp֎~i $etc j܂܂Ă܂B";                        }
    elsif ($err ==  7) { $mes = "ɑ݂Ă܂B";                                            }
    elsif ($err ==  8) { $mes = "̑͋Ă܂B";                                  }
    elsif ($err ==  9) { $mes = "ǗR[hႢ܂B";                                          }
    elsif ($err == 10) { $mes = "sȎwłBi$etcj";                                        }
    elsif ($err == 11) { $mes = "݋֎~[hɂȂĂ܂B";                                }
    elsif ($err == 12) { $mes = "GET\\bhɂ鏑݂֎~Ă܂B";                  }
    elsif ($err == 13) { $mes = "MURLsłB";                                           }
    elsif ($err == 14) { $mes = "bZ[W܂B${etc}byteȉɂĂB";          }
    elsif ($err == 15) { $mes = "Ae񐔃I[o[łB΂炭ĂxeĂB"; }
    elsif ($err == 99) { $mes = "$libname ̃o[WႢ܂Bver.$etcȍ~pB"; }
    else               { $mes = $err; }

print <<"EOF";

<?xml version="1.0" encoding="$charset" ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>G[</title>
</head>
<body>
<p>$mes<br />uEUBack{^ł߂肭B</p>
</body>
</html>
EOF

    exit(-1);
}

1;

;# end_of_file
